//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

SQLBasics::SQLBasics()
{
    Connected = false;

    DBDisconnect();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

SQLBasics::~SQLBasics()
{
    DBDisconnect();
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SQLBasics::DBConnect(char *Driver, char *Server, char *UID, char *PWD, char *Database)
{
    SQLRETURN Result;
    char ConnectString[MAXSQLBUFLEN];

    if(Connected)
        return false;

    sprintf(ConnectString, "DRIVER=%s; SERVER=%s; UID=%s; PWD=%s; DATABASE=%s;", Driver, Server, UID, PWD, Database);

    SQLCHAR ConnStrOut[MAXSQLBUFLEN];
    SQLSMALLINT cbConnStrOut = 0;

    // Allocate the environment handle
    Result = SQLAllocHandle(SQL_HANDLE_ENV, SQL_NULL_HANDLE, &SQLEnvironment);
    if(!SQL_SUCCEEDED(Result))
    {
        return false;
    }

    // Set the environment attributes
    Result = SQLSetEnvAttr(SQLEnvironment, SQL_ATTR_ODBC_VERSION, (SQLPOINTER) SQL_OV_ODBC2, SQL_IS_INTEGER);
    if(!SQL_SUCCEEDED(Result))
    {
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
        return false;
    }

    // Allocate the connection handle
    Result = SQLAllocHandle(SQL_HANDLE_DBC, SQLEnvironment, &SQLConnection);
    if(!SQL_SUCCEEDED(Result))
    {
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
        SQLFreeHandle(SQL_HANDLE_DBC, SQLConnection);
        return false;
    }

    // Set login timeout to 5 seconds.
    SQLSetConnectOption(SQLConnection, SQL_LOGIN_TIMEOUT, 5);
    SQLSetConnectOption(SQLConnection, SQL_CURSOR_TYPE, SQL_CURSOR_STATIC);

    // Connect
    Result = SQLDriverConnect(
        SQLConnection,            // Connection handle
        NULL,                     // Window handle
        (SQLCHAR *)ConnectString, // Input connect string
        SQL_NTS,                  // Null-terminated string
        ConnStrOut,               // Address of output buffer
        MAXSQLBUFLEN,             // Size of output buffer
        &cbConnStrOut,            // Address of output length
        SQL_DRIVER_NOPROMPT
    );

    if(!SQL_SUCCEEDED(Result))
    {
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
        SQLFreeHandle(SQL_HANDLE_DBC, SQLConnection);
        return false;
    }

    Connected = true;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SQLBasics::DBGetErrorMessage(char *ReturnChar)
{
    if(Connected)
	{
	    SQLCHAR     szSqlState[20];
	    SQLINTEGER  ssErr;
	    SQLSMALLINT cbErrorMsg;

	    SQLError(SQLEnvironment, SQLConnection, SQL_NULL_HSTMT, szSqlState, &ssErr, (SQLCHAR *)ReturnChar, MAXSQLCONNOUT, &cbErrorMsg);
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SQLBasics::DBDisconnect(void)
{
    if(Connected)
    {
        SQLDisconnect(SQLConnection);
        SQLFreeHandle(SQL_HANDLE_ENV, SQLEnvironment);
        SQLFreeHandle(SQL_HANDLE_DBC, SQLConnection);
    }

    SQLEnvironment = NULL;
    SQLEnvironment = NULL;

    Connected = false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SQLBasics::DBExecute(char *Statement, HSTMT *StatementHandle)
{
    if(!Connected)
        return false;

    SQLRETURN Result = 0;

    Result = SQLAllocHandle(SQL_HANDLE_STMT, SQLConnection, StatementHandle);
    if(SQL_SUCCEEDED(Result))
    {
        Result = SQLPrepare(*StatementHandle, (unsigned char *)Statement, strlen(Statement));
        if(SQL_SUCCEEDED(Result))
        {
            Result = SQLExecute(*StatementHandle);
            if(SQL_SUCCEEDED(Result))
            {
                return true;
            }
        }
    }

    return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SQLBasics::DBCloseCursor(HSTMT StatementHandle)
{
    if(Connected)
    {
        SQLFreeHandle(SQL_HANDLE_STMT, StatementHandle);
    }
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SQLBasics::DBFetch(HSTMT *StatementHandle)
{
    if(!Connected)
        return false;

    SQLRETURN Result = 0;

    Result = SQLFetch(*StatementHandle);
    if(SQL_SUCCEEDED(Result))
        return true;

    return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SQLBasics::DBGetData(HSTMT *StatementHandle, SQLUSMALLINT ColumnNumber, SQLSMALLINT TargetType, SQLPOINTER TargetValuePtr, SQLINTEGER BufferLength, SQLINTEGER *StrLen_or_IndPtr)
{
    if(!Connected)
        return false;

    SQLRETURN Result = SQLGetData(*StatementHandle, ColumnNumber, TargetType, TargetValuePtr, BufferLength, StrLen_or_IndPtr);

    if(SQL_SUCCEEDED(Result) && StrLen_or_IndPtr > 0)
        return true;

    return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

